
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")

# Set the objective function
m.setObjective(9*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14*x1 + 18*x2 >= 33, "organization_score")
m.addConstr(12*x1 + 11*x2 >= 30, "work_quality_rating")
m.addConstr(5*x1 - 7*x2 >= 0, "hours_constraint")
m.addConstr(14*x1 + 18*x2 <= 68, "max_organization_score")
m.addConstr(12*x1 + 11*x2 <= 77, "max_work_quality_rating")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Paul: {x1.x}")
    print(f"Hours worked by Laura: {x2.x}")
else:
    print("No optimal solution found")
