
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Paul", lb=0)  # Assuming hours cannot be negative
    x2 = model.addVar(name="hours_worked_by_Laura", lb=0)  # Assuming hours cannot be negative

    # Define objective function
    model.setObjective(9 * x1 + 2 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(14 * x1 + 18 * x2 >= 33, name="organization_score_constraint")
    model.addConstr(12 * x1 + 11 * x2 >= 30, name="work_quality_rating_constraint")
    model.addConstr(5 * x1 - 7 * x2 >= 0, name="another_constraint")
    model.addConstr(14 * x1 + 18 * x2 <= 68, name="upper_bound_organization_score")
    model.addConstr(12 * x1 + 11 * x2 <= 77, name="upper_bound_work_quality_rating")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Paul: {x1.varValue}")
        print(f"Hours worked by Laura: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
