
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by Mary
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Bill
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # hours worked by Laura


    # Set objective function
    m.setObjective(2.25 * x0 + 3.44 * x1 + 1.13 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(19 * x1 + 25 * x2 >= 41)
    m.addConstr(12 * x0 + 25 * x2 >= 36)
    m.addConstr(2 * x1 + 19 * x2 >= 39)
    m.addConstr(6 * x0 + 19 * x2 >= 35)
    m.addConstr(6 * x0 + 2 * x1 + 19 * x2 >= 48)
    m.addConstr(24 * x1 + 19 * x2 >= 29)
    m.addConstr(14 * x0 + 24 * x1 >= 25)
    m.addConstr(-6 * x0 + 3 * x1 >= 0)
    m.addConstr(12 * x0 + 19 * x1 <= 133)
    m.addConstr(12 * x0 + 25 * x2 <= 71)
    m.addConstr(12 * x0 + 19 * x1 + 25 * x2 <= 71)
    m.addConstr(6 * x0 + 19 * x2 <= 101)
    m.addConstr(6 * x0 + 2 * x1 + 19 * x2 <= 101)
    m.addConstr(24 * x1 + 19 * x2 <= 73)
    m.addConstr(14 * x0 + 24 * x1 <= 96)
    m.addConstr(14 * x0 + 24 * x1 + 19 * x2 <= 96)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
