
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Mary
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Bill
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Laura

    # Define the objective function
    model.setObjective(2.25*x0 + 3.44*x1 + 1.13*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(12*x0 <= 138)
    model.addConstr(6*x0 <= 155)
    model.addConstr(14*x0 <= 153)
    model.addConstr(19*x1 <= 138)
    model.addConstr(2*x1 <= 155)
    model.addConstr(24*x1 <= 153)
    model.addConstr(25*x2 <= 138)
    model.addConstr(19*x2 <= 155)
    model.addConstr(19*x2 <= 153)
    model.addConstr(19*x1 + 25*x2 >= 41)
    model.addConstr(12*x0 + 25*x2 >= 36)
    model.addConstr(2*x1 + 19*x2 >= 39)
    model.addConstr(6*x0 + 19*x2 >= 35)
    model.addConstr(6*x0 + 2*x1 + 19*x2 >= 48)
    model.addConstr(24*x1 + 19*x2 >= 29)
    model.addConstr(14*x0 + 24*x1 >= 25)
    model.addConstr(-6*x0 + 3*x1 >= 0)
    model.addConstr(12*x0 + 19*x1 <= 133)
    model.addConstr(12*x0 + 25*x2 <= 71)
    model.addConstr(12*x0 + 19*x1 + 25*x2 <= 71)
    model.addConstr(6*x0 + 19*x2 <= 101)
    model.addConstr(6*x0 + 2*x1 + 19*x2 <= 101)
    model.addConstr(24*x1 + 19*x2 <= 73)
    model.addConstr(14*x0 + 24*x1 <= 96)
    model.addConstr(14*x0 + 24*x1 + 19*x2 <= 96)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Mary: ", x0.varValue)
        print("Hours worked by Bill: ", x1.varValue)
        print("Hours worked by Laura: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
