
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    zinc = m.addVar(vtype=gp.GRB.INTEGER, name="zinc")
    vitamin_b4 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")
    vitamin_c = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
    vitamin_b12 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")

    # Set objective function
    m.setObjective(4.03 * zinc + 8.56 * vitamin_b4 + 7.71 * vitamin_c + 6.89 * vitamin_b12, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(11 * zinc + 7 * vitamin_b12 >= 43, "c1")
    m.addConstr(5 * vitamin_b4 + 4 * vitamin_c >= 46, "c2")
    m.addConstr(11 * zinc + 5 * vitamin_b4 + 4 * vitamin_c + 7 * vitamin_b12 >= 46, "c3")
    m.addConstr(5 * zinc + 9 * vitamin_b12 >= 27, "c4")
    m.addConstr(3 * vitamin_c + 9 * vitamin_b12 >= 28, "c5")
    m.addConstr(5 * zinc + 9 * vitamin_b4 + 9 * vitamin_b12 >= 33, "c6")
    m.addConstr(5 * zinc + 9 * vitamin_b4 + 3 * vitamin_c + 9 * vitamin_b12 >= 33, "c7")
    m.addConstr(-10 * zinc + 5 * vitamin_b4 >= 0, "c8")
    m.addConstr(2 * zinc - 7 * vitamin_b12 >= 0, "c9")
    m.addConstr(-4 * vitamin_b4 + 1 * vitamin_c >= 0, "c10")
    m.addConstr(11 * zinc + 5 * vitamin_b4 <= 100, "c11")
    m.addConstr(5 * vitamin_b4 + 4 * vitamin_c <= 156, "c12")
    m.addConstr(5 * vitamin_b4 + 7 * vitamin_b12 <= 99, "c13")
    m.addConstr(5 * vitamin_b4 + 4 * vitamin_c + 7 * vitamin_b12 <= 124, "c14")
    m.addConstr(3 * vitamin_c + 9 * vitamin_b12 <= 68, "c15")
    m.addConstr(9 * vitamin_b4 + 3 * vitamin_c <= 137, "c16")
    m.addConstr(9 * vitamin_b4 + 9 * vitamin_b12 <= 98, "c17")
    m.addConstr(5 * zinc + 3 * vitamin_c <= 38, "c18")
    m.addConstr(5 * zinc + 9 * vitamin_b4 + 3 * vitamin_c <= 94, "c19")
    m.addConstr(5 * zinc + 3 * vitamin_c + 9 * vitamin_b12 <= 56, "c20")
    m.addConstr(5 * zinc + 9 * vitamin_b4 + 9 * vitamin_b12 <= 78, "c21")
    m.addConstr(11 * zinc + 5 * vitamin_b4 + 4 * vitamin_c + 7 * vitamin_b12 <= 185, "c22") # Digestive support
    m.addConstr(5 * zinc + 9 * vitamin_b4 + 3 * vitamin_c + 9 * vitamin_b12 <= 155, "c23") # Cognitive performance


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
