
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name='x0', vtype=gurobi.GRB.INTEGER)  # milligrams of zinc
    x1 = model.addVar(name='x1')  # milligrams of vitamin B4
    x2 = model.addVar(name='x2')  # milligrams of vitamin C
    x3 = model.addVar(name='x3')  # milligrams of vitamin B12

    # Objective function
    model.setObjective(4.03 * x0 + 8.56 * x1 + 7.71 * x2 + 6.89 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(11 * x0 <= 185)
    model.addConstr(5 * x0 <= 155)
    model.addConstr(5 * x1 <= 185)
    model.addConstr(9 * x1 <= 155)
    model.addConstr(4 * x2 <= 185)
    model.addConstr(3 * x2 <= 155)
    model.addConstr(7 * x3 <= 185)
    model.addConstr(9 * x3 <= 155)
    model.addConstr(11 * x0 + 7 * x3 >= 43)
    model.addConstr(5 * x1 + 4 * x2 >= 46)
    model.addConstr(11 * x0 + 5 * x1 + 4 * x2 + 7 * x3 >= 46)
    model.addConstr(5 * x0 + 9 * x3 >= 27)
    model.addConstr(3 * x2 + 9 * x3 >= 28)
    model.addConstr(5 * x0 + 9 * x1 + 9 * x3 >= 33)
    model.addConstr(5 * x0 + 9 * x1 + 3 * x2 + 9 * x3 >= 33)
    model.addConstr(-10 * x0 + 5 * x1 >= 0)
    model.addConstr(2 * x0 - 7 * x3 >= 0)
    model.addConstr(-4 * x1 + x2 >= 0)
    model.addConstr(11 * x0 + 5 * x1 <= 100)
    model.addConstr(5 * x1 + 4 * x2 <= 156)
    model.addConstr(5 * x1 + 7 * x3 <= 99)
    model.addConstr(5 * x1 + 4 * x2 + 7 * x3 <= 124)
    model.addConstr(3 * x2 + 9 * x3 <= 68)
    model.addConstr(9 * x1 + 3 * x2 <= 137)
    model.addConstr(9 * x1 + 9 * x3 <= 98)
    model.addConstr(5 * x0 + 3 * x2 <= 38)
    model.addConstr(5 * x0 + 9 * x1 + 3 * x2 <= 94)
    model.addConstr(5 * x0 + 3 * x2 + 9 * x3 <= 56)
    model.addConstr(5 * x0 + 9 * x1 + 9 * x3 <= 78)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('x0: ', x0.varValue)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
        print('x3: ', x3.varValue)
    else:
        print('No solution found')

solve_optimization_problem()
