
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="cafeteria_chairs")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="blue_pens")
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="color_printers")


    # Set objective function
    model.setObjective(4.64 * x0 + 3.66 * x1 + 7.16 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(8 * x0 + 13 * x1 + 9 * x2 >= 22, "c0")
    model.addConstr(15 * x1 + 2 * x2 >= 22, "c1")
    model.addConstr(10 * x0 + 15 * x1 >= 35, "c2")
    model.addConstr(10 * x0 + 2 * x2 >= 42, "c3")
    model.addConstr(13 * x1 + 9 * x2 <= 52, "c4")
    model.addConstr(8 * x0 + 13 * x1 + 9 * x2 <= 52, "c5")
    model.addConstr(10 * x0 + 15 * x1 <= 164, "c6")
    model.addConstr(10 * x0 + 15 * x1 + 2 * x2 <= 164, "c7")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", model.objVal)
        print("Cafeteria chairs:", x0.x)
        print("Blue pens:", x1.x)
        print("Color printers:", x2.x)

except gp.GurobiError as e:
    print(f"Gurobi error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if Gurobi is installed and licensed correctly.")

