
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='cafeteria_chairs', vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name='blue_pens', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='color_printers', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(4.64 * x0 + 3.66 * x1 + 7.16 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(8 * x0 + 13 * x1 + 9 * x2 >= 22)
    model.addConstr(15 * x1 + 2 * x2 >= 22)
    model.addConstr(10 * x0 + 15 * x1 >= 35)
    model.addConstr(10 * x0 + 2 * x2 >= 42)
    model.addConstr(13 * x1 + 9 * x2 <= 52)
    model.addConstr(8 * x0 + 13 * x1 + 9 * x2 <= 52)
    model.addConstr(10 * x0 + 15 * x1 <= 164)
    model.addConstr(10 * x0 + 15 * x1 + 2 * x2 <= 164)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Cafeteria Chairs: ', x0.varValue)
        print('Blue Pens: ', x1.varValue)
        print('Color Printers: ', x2.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
