
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
bill_hours = model.addVar(vtype=gp.GRB.INTEGER, name="bill_hours")
hank_hours = model.addVar(vtype=gp.GRB.INTEGER, name="hank_hours")
peggy_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="peggy_hours")


# Set objective function
model.setObjective(1.88 * bill_hours + 3.92 * hank_hours + 4.99 * peggy_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * bill_hours + 24 * hank_hours <= 246, "c0")
model.addConstr(24 * hank_hours + 14 * peggy_hours <= 146, "c1")
model.addConstr(3 * bill_hours + 24 * hank_hours + 14 * peggy_hours <= 146, "c2")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: {model.objVal}")
    print(f"Bill's hours: {bill_hours.x}")
    print(f"Hank's hours: {hank_hours.x}")
    print(f"Peggy's hours: {peggy_hours.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

