
from gurobipy import *

# Create a new model
m = Model("Work_Hours_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bill")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Hank")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Peggy")

# Set the objective function
m.setObjective(1.88*x1 + 3.92*x2 + 4.99*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 24*x2 <= 246, name="Bill_and_Hank_work_quality")
m.addConstr(24*x2 + 14*x3 <= 146, name="Hank_and_Peggy_work_quality")
m.addConstr(3*x1 + 24*x2 + 14*x3 <= 146, name="Total_work_quality")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Bill: {x1.x}")
    print(f"Hours worked by Hank: {x2.x}")
    print(f"Hours worked by Peggy: {x3.x}")
else:
    print("No optimal solution found.")
