
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Bill", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="hours_worked_by_Hank", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="hours_worked_by_Peggy")

    # Objective function
    model.setObjective(1.88*x1 + 3.92*x2 + 4.99*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*x1 <= 311, name="Bill_work_quality")
    model.addConstr(24*x2 <= 311, name="Hank_work_quality")
    model.addConstr(14*x3 <= 311, name="Peggy_work_quality")
    model.addConstr(3*x1 + 24*x2 <= 246, name="Bill_Hank_work_quality")
    model.addConstr(24*x2 + 14*x3 <= 146, name="Hank_Peggy_work_quality")
    model.addConstr(3*x1 + 24*x2 + 14*x3 <= 146, name="Total_work_quality")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bill: {x1.varValue}")
        print(f"Hours worked by Hank: {x2.varValue}")
        print(f"Hours worked by Peggy: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
