
from gurobipy import Model, GRB

# Create a new model
m = Model("minimize_labor_cost")

# Create variables
dale = m.addVar(vtype=GRB.INTEGER, name="dale")
jean = m.addVar(vtype=GRB.INTEGER, name="jean")
bill = m.addVar(vtype=GRB.INTEGER, name="bill")
ringo = m.addVar(vtype=GRB.INTEGER, name="ringo")
hank = m.addVar(vtype=GRB.INTEGER, name="hank")
bobby = m.addVar(vtype=GRB.INTEGER, name="bobby")
laura = m.addVar(vtype=GRB.INTEGER, name="laura")


# Set objective function
m.setObjective(6.93 * dale + 5.42 * jean + 5.15 * bill + 5.74 * ringo + 1.96 * hank + 5.68 * bobby + 2.71 * laura, GRB.MINIMIZE)

# Add constraints from resources/attributes
r0_ub = 223
r1_ub = 340
r0_coeffs = [2, 14, 14, 12, 12, 1, 3]
r1_coeffs = [11, 7, 5, 8, 10, 14, 11]

for i, coeff in enumerate(r0_coeffs):
    m.addConstr(coeff * m.getVars()[i] <= r0_ub)

for i, coeff in enumerate(r1_coeffs):
    m.addConstr(coeff * m.getVars()[i] <= r1_ub)


# Add other constraints from the input
constraints = [
    (bill, ringo, 29, ">="), (bill, bobby, 27, ">="), (dale, bill, 28, ">="), (bill, hank, 28, ">="), (bobby, laura, 15, ">="), (jean, laura, 20, ">="), (hank, laura, 29, ">="), (bill, laura, 31, ">="), (dale, hank, 10, ">="), (ringo, bobby, 18, ">="), (jean, bobby, 15, ">="), (dale, laura, 27, ">="), (ringo, laura, 17, ">="), (jean, bill, 25, ">="), (jean, hank, 11, ">="), (dale, bill, ringo, 25, ">="), (bill, ringo, hank, 25, ">="), (dale, jean, bill, 25, ">="), (jean, bill, laura, 25, ">="), (dale, hank, bobby, 25, ">="), (bill, hank, laura, 25, ">="), (dale, bill, laura, 25, ">="), (jean, bill, ringo, 25, ">="), (dale, jean, bobby, 25, ">="), (jean, bobby, laura, 25, ">="), (dale, hank, laura, 25, ">="), (ringo, hank, laura, 25, ">="), (jean, hank, laura, 25, ">="), (jean, ringo, hank, 25, ">="), (bill, hank, bobby, 25, ">="), (dale, jean, laura, 25, ">="), (jean, hank, bobby, 25, ">="), (dale, jean, hank, 25, ">="), (jean, ringo, bobby, 25, ">="), (bill, ringo, bobby, 25, ">="), (jean, bill, bobby, 25, ">="), (ringo, bobby, laura, 25, ">="), (dale, bobby, laura, 25, ">="), (dale, jean, ringo, 25, ">="), (dale, bill, bobby, 25, ">="), (dale, bill, ringo, 17, ">="), (bill, ringo, hank, 17, ">="), (dale, jean, bill, 17, ">="), (jean, bill, laura, 17, ">="), (dale, hank, bobby, 17, ">="), (bill, hank, laura, 17, ">="), (dale, bill, laura, 17, ">="), (jean, bill, ringo, 17, ">="), (dale, jean, bobby, 17, ">="), (jean, bobby, laura, 17, ">="), (dale, hank, laura, 17, ">="), (ringo, hank, laura, 17, ">="), (jean, hank, laura, 17, ">="), (jean, ringo, hank, 17, ">="), (bill, hank, bobby, 17, ">="), (dale, jean, laura, 17, ">="), (jean, hank, bobby, 17, ">="), (dale, jean, hank, 17, ">="), (jean, ringo, bobby, 17, ">="), (bill, ringo, bobby, 17, ">="), (jean, bill, bobby, 17, ">="), (ringo, bobby, laura, 17, ">="), (dale, bobby, laura, 17, ">="), (dale, jean, ringo, 17, ">="), (dale, bill, bobby, 17, ">=")
]

org_score = [2, 14, 14, 12, 12, 1, 3]
likelihood_to_quit = [11, 7, 5, 8, 10, 14, 11]
vars = [dale, jean, bill, ringo, hank, bobby, laura]

for constraint in constraints:
    lhs = 0
    rhs = constraint[-2]
    op = constraint[-1]

    if len(constraint) == 4:
        var1, var2, rhs, op = constraint
        lhs = org_score[vars.index(var1)] * var1 + org_score[vars.index(var2)] * var2
    elif len(constraint) == 5:
        var1, var2, var3, rhs, op = constraint
        lhs = org_score[vars.index(var1)] * var1 + org_score[vars.index(var2)] * var2 + org_score[vars.index(var3)] * var3
    elif len(constraint) == 8:
        dale, jean, bill, ringo, hank, bobby, laura, rhs, op = constraint
        lhs = sum(org_score[i] * vars[i] for i in range(7))
    elif len(constraint) == 4 and isinstance(constraint[0], int):
        c1, var1, var2, op = constraint
        lhs = c1 * var1 + constraint[2] * var2
    
    if op == ">=":
        m.addConstr(lhs >= rhs)
    elif op == "<=":
        m.addConstr(lhs <= rhs)
    elif op == "=":
        m.addConstr(lhs == rhs)

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")
