
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hamburgers = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hamburgers")
peanutbutter_sandwiches = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peanutbutter_sandwiches")


# Set objective function
m.setObjective(7 * hamburgers + 8 * peanutbutter_sandwiches, GRB.MINIMIZE)

# Add constraints
m.addConstr(17 * hamburgers + 3 * peanutbutter_sandwiches >= 84, "cost_lower_bound")
m.addConstr(18 * hamburgers + 1 * peanutbutter_sandwiches >= 19, "sourness_lower_bound")
m.addConstr(4 * hamburgers - 9 * peanutbutter_sandwiches >= 0, "hamburgers_peanutbutter_ratio")
m.addConstr(17 * hamburgers + 3 * peanutbutter_sandwiches <= 158, "cost_upper_bound")
m.addConstr(18 * hamburgers + 1 * peanutbutter_sandwiches <= 93, "sourness_upper_bound")



# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution found:")
    print(f"hamburgers: {hamburgers.x}")
    print(f"peanutbutter_sandwiches: {peanutbutter_sandwiches.x}")
    print(f"Objective value: {m.objVal}")

