
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Add variables: hamburgers (x1) and peanutbutter sandwiches (x2)
x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hamburgers")
x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peanutbutter_sandwiches")

# Set the objective function: Minimize 7*x1 + 8*x2
model.setObjective(7*x1 + 8*x2, GRB.MINIMIZE)

# Add constraints
model.addConstr(17*x1 + 3*x2 >= 84, name="total_cost_min")
model.addConstr(18*x1 + 1*x2 >= 19, name="sourness_index_min")
model.addConstr(4*x1 - 9*x2 >= 0, name="hamburgers_vs_sandwiches")
model.addConstr(17*x1 + 3*x2 <= 158, name="total_cost_max")
model.addConstr(18*x1 + 1*x2 <= 93, name="sourness_index_max")

# Optimize the model
model.optimize()

# Check if an optimal solution was found
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"hamburgers: {x1.x}, peanutbutter sandwiches: {x2.x}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found")
