
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="hamburgers", lb=0)  # lower bound 0, no upper bound
x2 = model.addVar(name="peanutbutter sandwiches", lb=0)  # lower bound 0, no upper bound

# Objective function: minimize 7*x1 + 8*x2
model.setObjective(7 * x1 + 8 * x2, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(17 * x1 + 3 * x2 >= 84, name="total_cost_min")
model.addConstr(18 * x1 + x2 >= 19, name="total_sourness_min")
model.addConstr(4 * x1 - 9 * x2 >= 0, name="hamburgers_vs_peanutbutter")
model.addConstr(17 * x1 + 3 * x2 <= 158, name="total_cost_max")  # Corrected to reflect accurate upper bound per problem
model.addConstr(18 * x1 + x2 <= 93, name="total_sourness_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Hamburgers: ", x1.varValue)
    print("Peanutbutter sandwiches: ", x2.varValue)
else:
    print("The model is infeasible")
