
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    chicken = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken")
    pasta = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pasta")
    corn = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="corn")
    beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="beans")


    # Set objective function
    m.setObjective(7*chicken + 5*pasta + 7*corn + 4*beans, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(19*chicken + 16*beans >= 56)
    m.addConstr(19*chicken + 4*corn >= 38)
    m.addConstr(4*pasta + 4*corn >= 36)
    m.addConstr(19*chicken + 4*pasta + 4*corn >= 53)
    m.addConstr(19*chicken + 4*corn + 16*beans >= 53)
    m.addConstr(4*pasta + 4*corn + 16*beans >= 53)
    m.addConstr(19*chicken + 4*pasta + 4*corn >= 66)
    m.addConstr(19*chicken + 4*corn + 16*beans >= 66)
    m.addConstr(4*pasta + 4*corn + 16*beans >= 66)
    m.addConstr(19*chicken + 4*pasta + 4*corn >= 62)
    m.addConstr(19*chicken + 4*corn + 16*beans >= 62)
    m.addConstr(4*pasta + 4*corn + 16*beans >= 62)
    m.addConstr(12*chicken + 10*pasta >= 58)
    m.addConstr(12*chicken + 10*pasta + 4*beans >= 86)
    m.addConstr(12*chicken + 22*corn + 4*beans >= 86)
    m.addConstr(12*chicken + 10*pasta + 4*beans >= 98)
    m.addConstr(12*chicken + 22*corn + 4*beans >= 98)
    m.addConstr(19*chicken + 4*pasta <= 159)
    m.addConstr(4*pasta + 16*beans <= 176)
    m.addConstr(4*pasta + 4*corn <= 159)
    m.addConstr(19*chicken + 4*pasta + 4*corn <= 302)
    m.addConstr(4*pasta + 4*corn + 16*beans <= 141)
    m.addConstr(19*chicken + 4*pasta + 16*beans <= 328)
    m.addConstr(19*chicken + 4*pasta + 4*corn + 16*beans <= 328)
    m.addConstr(12*chicken + 22*corn <= 328)
    m.addConstr(10*pasta + 4*beans <= 435)
    m.addConstr(12*chicken + 10*pasta + 22*corn + 4*beans <= 435)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print("Optimal solution:")
        print(f"  Chicken Drumsticks: {chicken.x}")
        print(f"  Bowls of Pasta: {pasta.x}")
        print(f"  Corn Cobs: {corn.x}")
        print(f"  Black Beans: {beans.x}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
