
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="chicken_drumsticks", lb=0)
    x1 = model.addVar(name="bowls_of_pasta", lb=0)
    x2 = model.addVar(name="corn_cobs", lb=0, integrality=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="black_beans", lb=0)

    # Objective function
    model.setObjective(7 * x0 + 5 * x1 + 7 * x2 + 4 * x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(19 * x0 <= 423)
    model.addConstr(12 * x0 <= 556)
    model.addConstr(4 * x1 <= 423)
    model.addConstr(10 * x1 <= 556)
    model.addConstr(4 * x2 <= 423)
    model.addConstr(22 * x2 <= 556)
    model.addConstr(16 * x3 <= 423)
    model.addConstr(4 * x3 <= 556)
    model.addConstr(19 * x0 + 16 * x3 >= 56)
    model.addConstr(19 * x0 + 4 * x2 >= 38)
    model.addConstr(4 * x1 + 4 * x2 >= 36)
    model.addConstr(19 * x0 + 4 * x1 + 4 * x2 >= 53)
    model.addConstr(19 * x0 + 4 * x2 + 16 * x3 >= 53)
    model.addConstr(4 * x1 + 4 * x2 + 16 * x3 >= 53)
    model.addConstr(19 * x0 + 4 * x1 + 4 * x2 >= 66)
    model.addConstr(19 * x0 + 4 * x2 + 16 * x3 >= 66)
    model.addConstr(4 * x1 + 4 * x2 + 16 * x3 >= 66)
    model.addConstr(19 * x0 + 4 * x1 + 4 * x2 >= 62)
    model.addConstr(19 * x0 + 4 * x2 + 16 * x3 >= 62)
    model.addConstr(4 * x1 + 4 * x2 + 16 * x3 >= 62)
    model.addConstr(12 * x0 + 10 * x1 >= 58)
    model.addConstr(12 * x0 + 10 * x1 + 4 * x3 >= 86)
    model.addConstr(12 * x0 + 22 * x2 + 4 * x3 >= 86)
    model.addConstr(12 * x0 + 10 * x1 + 4 * x3 >= 98)
    model.addConstr(12 * x0 + 22 * x2 + 4 * x3 >= 98)
    model.addConstr(19 * x0 + 4 * x1 <= 159)
    model.addConstr(4 * x1 + 16 * x3 <= 176)
    model.addConstr(4 * x1 + 4 * x2 <= 159)
    model.addConstr(19 * x0 + 4 * x1 + 4 * x2 <= 302)
    model.addConstr(4 * x1 + 4 * x2 + 16 * x3 <= 141)
    model.addConstr(19 * x0 + 4 * x1 + 16 * x3 <= 328)
    model.addConstr(19 * x0 + 4 * x1 + 4 * x2 + 16 * x3 <= 328)
    model.addConstr(12 * x0 + 22 * x2 <= 328)
    model.addConstr(10 * x1 + 4 * x3 <= 435)
    model.addConstr(12 * x0 + 10 * x1 + 22 * x2 + 4 * x3 <= 435)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Chicken drumsticks: ", x0.varValue)
        print("Bowls of pasta: ", x1.varValue)
        print("Corn cobs: ", x2.varValue)
        print("Black beans: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
