
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # milligrams of vitamin B5
    x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="x1") # milligrams of potassium
    x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="x2") # milligrams of vitamin E


    # Set objective function
    m.setObjective(4.9*x0**2 + 9.78*x0*x1 + 5.23*x0*x2 + 4.04*x2**2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2.14*x1**2 + 4.34*x2**2 >= 11, "c0")
    m.addConstr(2.14*x0 + 4.34*x2 >= 19, "c1")
    m.addConstr(2.14*x0**2 + 0.0*x1**2 + 4.34*x2**2 >= 16, "c2")
    m.addConstr(2.14*x0**2 + 0.0*x1**2 <= 33, "c3")
    m.addConstr(2.14*x0 + 4.34*x2 <= 57, "c4")
    m.addConstr(2.14*x0 + 0.0*x1 + 4.34*x2 <= 57, "c5")
    m.addConstr(1.45*x0**2 + 3.57*x2**2 <= 41, "c6")
    m.addConstr(1.45*x0 + 4.45*x1 <= 20, "c7")
    m.addConstr(1.45*x0**2 + 4.45*x1**2 + 3.57*x2**2 <= 24, "c8")
    m.addConstr(1.45*x0 + 4.45*x1 + 3.57*x2 <= 24, "c9")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
