
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")  # milligrams of vitamin B5
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2", vtype=gurobi.GRB.INTEGER)  # milligrams of potassium
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin E

    # Objective function
    model.setObjective(4.9*x1**2 + 9.78*x1*x2 + 5.23*x1*x3 + 4.04*x3**2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x2**2 + x3**2 >= 11)
    model.addConstr(2.14*x1 + 4.34*x3 >= 19)
    model.addConstr((2.14*x1)**2 + (4.34*x3)**2 >= 16)
    model.addConstr((2.14*x1)**2 <= 33)
    model.addConstr(2.14*x1 + 4.34*x3 <= 57)
    model.addConstr(2.14*x1 + 4.34*x3 <= 57)
    model.addConstr((1.45*x1)**2 + (3.57*x3)**2 <= 41)
    model.addConstr(1.45*x1 + 4.45*x2 <= 20)
    model.addConstr((1.45*x1)**2 + (4.45*x2)**2 + (3.57*x3)**2 <= 24)
    model.addConstr(1.45*x1 + 4.45*x2 + 3.57*x3 <= 24)

    # Solve the problem
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"milligrams of vitamin B5: {x1.varValue}")
        print(f"milligrams of potassium: {x2.varValue}")
        print(f"milligrams of vitamin E: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
