
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cantaloupes = m.addVar(vtype=GRB.INTEGER, name="cantaloupes")
potatoes = m.addVar(vtype=GRB.CONTINUOUS, name="potatoes")

# Set objective function
m.setObjective(4*cantaloupes**2 + 2*cantaloupes*potatoes + 9*potatoes**2 + 9*cantaloupes, GRB.MINIMIZE)

# Add constraints
m.addConstr(3.42*cantaloupes + 2.7*potatoes >= 20, "calcium_min")
m.addConstr(2.08*cantaloupes + 2.45*potatoes >= 28, "cost_min")
m.addConstr(3*cantaloupes - 10*potatoes >= 0, "cantaloupe_potato_ratio")
m.addConstr(3.42*cantaloupes + 2.7*potatoes <= 60, "calcium_max")  # Corrected upper bound constraint
m.addConstr(2.08*cantaloupes + 2.45*potatoes <= 73, "cost_max")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution found:")
    print(f"Cantaloupes: {cantaloupes.x}")
    print(f"Potatoes: {potatoes.x}")
    print(f"Objective value: {m.objVal}")

