
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="cantaloupes")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="potatoes", lb=0)

# Set the objective function
m.setObjective(4*x1**2 + 2*x1*x2 + 9*x2**2 + 9*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(3.42*x1 + 2.7*x2 >= 20, name="calcium_min")
m.addConstr(2.08*x1 + 2.45*x2 >= 28, name="cost_min")
m.addConstr(3*x1 - 10*x2 >= 0, name="expression_constraint")
m.addConstr(3.42*x1 + 2.7*x2 <= 60, name="calcium_max")
m.addConstr(2.08*x1 + 2.45*x2 <= 86, name="cost_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Cantaloupes:", x1.x)
    print("Potatoes:", x2.x)
else:
    print("No optimal solution found.")
