
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
cantaloupes = model.addVar(name="cantaloupes", vtype=gurobi.GRB.INTEGER)
potatoes = model.addVar(name="potatoes")

# Objective function: 4*cantaloupes^2 + 2*cantaloupes*potatoes + 9*potatoes^2 + 9*cantaloupes
model.setObjective(4*cantaloupes**2 + 2*cantaloupes*potatoes + 9*potatoes**2 + 9*cantaloupes, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(3.42*cantaloupes + 2.7*potatoes >= 20, name="calcium_requirement")
model.addConstr(2.08*cantaloupes + 2.45*potatoes >= 28, name="cost_requirement")
model.addConstr(3*cantaloupes - 10*potatoes >= 0, name="cantaloupes_vs_potatoes")
model.addConstr(3.42*cantaloupes + 2.7*potatoes <= 60, name="max_calcium")
model.addConstr(2.08*cantaloupes + 2.45*potatoes <= 73, name="max_cost")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Cantaloupes: ", cantaloupes.varValue)
    print("Potatoes: ", potatoes.varValue)
else:
    print("The model is infeasible")
