
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="chicken_drumsticks")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="ravioli")
x2 = m.addVar(vtype=GRB.INTEGER, name="strips_of_bacon")


# Set objective function
m.setObjective(6*x0**2 + 3*x1**2 + 5*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x0 + 9*x2 >= 34, "fat_constraint1")
m.addConstr(19*x0**2 + 12*x1**2 >= 25, "cost_constraint1")
m.addConstr(12*x1**2 + 12*x2**2 >= 30, "cost_constraint2")
m.addConstr(20*x0 + 9*x2 <= 70, "fat_constraint2")
m.addConstr(20*x0**2 + 10*x1**2 <= 101, "fat_constraint3")

# Resource Constraints
m.addConstr(20*x0 + 10*x1 + 9*x2 <= 113, "fat_resource")
m.addConstr(19*x0 + 12*x2 <= 95, "cost_constraint3")
m.addConstr(12*x1 + 12*x2 <= 61, "cost_constraint4")
m.addConstr(19*x0 + 12*x1 + 12*x2 <= 143, "cost_resource")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('chicken_drumsticks:', x0.x)
    print('ravioli:', x1.x)
    print('strips_of_bacon:', x2.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

