
import gurobi

def optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="chicken_drumsticks", vtype=gurobi.GRB.INTEGER)  # integer
    x1 = model.addVar(name="ravioli")  # continuous
    x2 = model.addVar(name="strips_of_bacon", vtype=gurobi.GRB.INTEGER)  # integer
    
    # Objective function
    model.setObjective(6*x0**2 + 3*x1**2 + 5*x1 + 7*x2, gurobi.GRB.MAXIMIZE)
    
    # Constraints
    model.addConstr(20*x0 + 9*x2 >= 34, name="min_fat")
    model.addConstr(19*x0**2 + 12*x1**2 >= 25, name="min_cost_cd_ravioli")
    model.addConstr(12*x1**2 + 12*x2**2 >= 30, name="min_cost_ravioli_bacon")
    model.addConstr(20*x0 + 9*x2 <= 70, name="max_fat_cd_bacon")
    model.addConstr(20*x0**2 + 10*x1**2 <= 101, name="max_fat_cd_ravioli")
    model.addConstr(20*x0 + 10*x1 + 9*x2 <= 101, name="max_total_fat")
    model.addConstr(19*x0 + 12*x2 <= 95, name="max_cost_cd_bacon")
    model.addConstr(12*x1 + 12*x2 <= 61, name="max_cost_ravioli_bacon")
    model.addConstr(19*x0 + 12*x1 + 12*x2 <= 61, name="max_total_cost")
    
    # Optimize
    model.optimize()
    
    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Chicken drumsticks: ", x0.varValue)
        print("Ravioli: ", x1.varValue)
        print("Strips of bacon: ", x2.varValue)
    else:
        print("No optimal solution found")

optimization_problem()
