
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="rubber_gloves")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="dish_soap_bottles")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="toilet_paper_rolls")
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="cookies")


    # Set objective function
    m.setObjective(5*x0 + 2*x1 + 7*x2 + 6*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(15.84*x0 + 9.19*x2 >= 127)
    m.addConstr(3.04*x1 + 9.19*x2 >= 84)
    m.addConstr(9.19*x2 + 26.5*x3 >= 71)
    m.addConstr(15.84*x0 + 3.04*x1 + 9.19*x2 >= 122)
    m.addConstr(15.84*x0 + 3.04*x1 + 26.5*x3 >= 122)
    m.addConstr(15.84*x0 + 9.19*x2 + 26.5*x3 >= 122)
    m.addConstr(15.84*x0 + 3.04*x1 + 9.19*x2 >= 133)
    m.addConstr(15.84*x0 + 3.04*x1 + 26.5*x3 >= 133)
    m.addConstr(15.84*x0 + 9.19*x2 + 26.5*x3 >= 133)
    m.addConstr(15.84*x0 + 3.04*x1 + 9.19*x2 >= 105)
    m.addConstr(15.84*x0 + 3.04*x1 + 26.5*x3 >= 105)
    m.addConstr(15.84*x0 + 9.19*x2 + 26.5*x3 >= 105)
    m.addConstr(15.84*x0 + 3.04*x1 <= 511)
    m.addConstr(9.19*x2 + 26.5*x3 <= 424)
    m.addConstr(3.04*x1 + 26.5*x3 <= 569)
    m.addConstr(15.84*x0 + 9.19*x2 <= 154)
    m.addConstr(15.84*x0 + 3.04*x1 + 9.19*x2 + 26.5*x3 <= 154)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The problem is infeasible.")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
