
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="rubber_gloves", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="dish_soap_bottles", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="toilet_paper_rolls", vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name="cookies", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(5*x1 + 2*x2 + 7*x3 + 6*x4, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(15.84*x1 + 9.19*x3 >= 127)
m.addConstr(3.04*x2 + 9.19*x3 >= 84)
m.addConstr(9.19*x3 + 26.5*x4 >= 71)
m.addConstr(15.84*x1 + 3.04*x2 + 9.19*x3 >= 122)
m.addConstr(15.84*x1 + 3.04*x2 + 26.5*x4 >= 122)
m.addConstr(15.84*x1 + 9.19*x3 + 26.5*x4 >= 122)
m.addConstr(15.84*x1 + 3.04*x2 + 9.19*x3 >= 133)
m.addConstr(15.84*x1 + 3.04*x2 + 26.5*x4 >= 133)
m.addConstr(15.84*x1 + 9.19*x3 + 26.5*x4 >= 133)
m.addConstr(15.84*x1 + 3.04*x2 + 9.19*x3 >= 105)
m.addConstr(15.84*x1 + 3.04*x2 + 26.5*x4 >= 105)
m.addConstr(15.84*x1 + 9.19*x3 + 26.5*x4 >= 105)
m.addConstr(15.84*x1 + 3.04*x2 <= 511)
m.addConstr(9.19*x3 + 26.5*x4 <= 424)
m.addConstr(3.04*x2 + 26.5*x4 <= 569)
m.addConstr(15.84*x1 + 9.19*x3 <= 154)
m.addConstr(15.84*x1 + 3.04*x2 + 9.19*x3 + 26.5*x4 <= 154)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Rubber Gloves: ", x1.varValue)
    print("Dish Soap Bottles: ", x2.varValue)
    print("Toilet Paper Rolls: ", x3.varValue)
    print("Cookies: ", x4.varValue)
else:
    print("The model is infeasible")
