
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="cherry_pies", vtype=gp.GRB.INTEGER)  # integer
x1 = m.addVar(name="sashimi")  # continuous
x2 = m.addVar(name="knishes")  # continuous
x3 = m.addVar(name="black_beans", vtype=gp.GRB.INTEGER)  # integer

# Define the objective function
m.setObjective(7.88 * x0**2 + 2.33 * x0 * x2 + 2.88 * x0 * x3 + 3.07 * x1**2 + 9.16 * x1 * x2 + 5.11 * x1 * x3 + 4.09 * x0, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * x0 <= 103)
m.addConstr(12 * x0 <= 210)
m.addConstr(3 * x1 <= 103)
m.addConstr(6 * x1 <= 210)
m.addConstr(12 * x2 <= 103)
m.addConstr(9 * x2 <= 210)
m.addConstr(11 * x3 <= 103)
m.addConstr(11 * x3 <= 210)

m.addConstr(x0**2 + x1**2 + x2**2 >= 14)
m.addConstr(x1 + x2 + x3 >= 14)
m.addConstr(x0 + x1 + x3 >= 14)
m.addConstr(x0 + x2 + x3 >= 14)
m.addConstr(x0 + x1 + x2 >= 25)
m.addConstr(x1 + x2 + x3 >= 25)
m.addConstr(x0 + x1 + x3 >= 25)
m.addConstr(x0 + x2 + x3 >= 25)
m.addConstr(x0 + x1 + x2 >= 16)
m.addConstr(x1**2 + x2**2 + x3**2 >= 16)
m.addConstr(x0**2 + x1**2 + x3**2 >= 16)
m.addConstr(x0**2 + x1**2 + x2**2 >= 16)
m.addConstr(x0 + x2 + x3 >= 16)
m.addConstr(x0 + x1 + x2 >= 16)
m.addConstr(x1 + x2 + x3 >= 16)

m.addConstr(12 * x0 + 6 * x1 >= 36)
m.addConstr(9 * x2**2 + 11 * x3**2 >= 17)
m.addConstr(12 * x0**2 + 9 * x2**2 >= 46)
m.addConstr(6 * x1 + 9 * x2 >= 47)
m.addConstr(12 * x0**2 + 11 * x3**2 >= 31)
m.addConstr(6 * x1**2 + 11 * x3**2 >= 19)
m.addConstr(12 * x0**2 + 6 * x1**2 + 9 * x2**2 >= 27)
m.addConstr(12 * x0**2 + 9 * x2**2 + 11 * x3**2 >= 27)
m.addConstr(12 * x0 + 6 * x1 + 9 * x2 >= 49)
m.addConstr(12 * x0 + 9 * x2 + 11 * x3 >= 49)
m.addConstr(5 * x0 - 9 * x1 - 2 * x3 >= 0)
m.addConstr(12 * x2**2 + 11 * x3**2 <= 65)
m.addConstr(8 * x0**2 + 3 * x1**2 <= 31)
m.addConstr(3 * x1**2 + 12 * x2**2 <= 68)
m.addConstr(8 * x0 + 3 * x1 + 11 * x3 <= 89)
m.addConstr(3 * x1 + 9 * x2 + 11 * x3 <= 66)
m.addConstr(8 * x0**2 + 12 * x2**2 + 11 * x3**2 <= 75)
m.addConstr(8 * x0 + 3 * x1 + 12 * x2 + 11 * x3 <= 75)
m.addConstr(6 * x1 + 11 * x3 <= 123)
m.addConstr(9 * x2 + 11 * x3 <= 62)
m.addConstr(12 * x0 + 6 * x1 <= 89)
m.addConstr(6 * x1**2 + 9 * x2**2 <= 111)
m.addConstr(12 * x0 + 9 * x2 <= 62)
m.addConstr(12 * x0**2 + 6 * x1**2 + 9 * x2**2 <= 196)
m.addConstr(12 * x0 + 9 * x2 + 11 * x3 <= 63)
m.addConstr(6 * x1**2 + 9 * x2**2 + 11 * x3**2 <= 95)
m.addConstr(12 * x0 + 6 * x1 + 9 * x2 + 11 * x3 <= 95)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
