
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("resource_allocation")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="logistics_companies")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="air_defense_batteries")
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="artillery_batteries")


    # Set objective function
    model.setObjective(3.19 * x0 + 5.15 * x1 + 4.08 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6 * x0 + 3 * x1 + 4 * x2 >= 24, "logistical_capacity_min")
    model.addConstr(1 * x0 + 11 * x1 + 1 * x2 >= 16, "mobility_rating_min")
    model.addConstr(6 * x0 + 3 * x1 <= 67, "logistical_capacity_max1")
    model.addConstr(6 * x0 + 4 * x2 <= 44, "logistical_capacity_max2")
    model.addConstr(6 * x0 + 3 * x1 + 4 * x2 <= 44, "logistical_capacity_max3")
    model.addConstr(11 * x1 + 1 * x2 <= 34, "mobility_rating_max1")
    model.addConstr(1 * x0 + 11 * x1 + 1 * x2 <= 34, "mobility_rating_max2")
    model.addConstr(1 * x1 + 4 * x2 <= 72, "fuel_demand_max1")
    model.addConstr(8 * x0 + 4 * x2 <= 47, "fuel_demand_max2")
    model.addConstr(8 * x0 + 1 * x1 <= 51, "fuel_demand_max3")
    model.addConstr(8 * x0 + 1 * x1 + 4 * x2 <= 68, "fuel_demand_max4")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('logistics_companies:', x0.x)
        print('air_defense_batteries:', x1.x)
        print('artillery_batteries:', x2.x)

    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
