
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="logistics_companies", vtype=gurobi.GRB.INTEGER)
x1 = model.addVar(name="air_defense_batteries", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="artillery_batteries", vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(3.19*x0 + 5.15*x1 + 4.08*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(6*x0 <= 6)
model.addConstr(x0 <= 1)
model.addConstr(8*x0 <= 8)
model.addConstr(3*x1 <= 3)
model.addConstr(11*x1 <= 11)
model.addConstr(x1 <= 1)
model.addConstr(4*x2 <= 4)
model.addConstr(x2 <= 1)
model.addConstr(4*x2 <= 4)
model.addConstr(6*x0 + 4*x2 >= 24)
model.addConstr(x0 + 11*x1 + x2 >= 16)
model.addConstr(6*x0 + 3*x1 <= 67)
model.addConstr(6*x0 + 4*x2 <= 44)
model.addConstr(6*x0 + 3*x1 + 4*x2 <= 44)
model.addConstr(11*x1 + x2 <= 34)
model.addConstr(x0 + 11*x1 + x2 <= 34)
model.addConstr(x1 + 4*x2 <= 72)
model.addConstr(8*x0 + 4*x2 <= 47)
model.addConstr(8*x0 + x1 <= 51)
model.addConstr(8*x0 + x1 + 4*x2 <= 68)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Logistics companies: ", x0.varValue)
    print("Air defense batteries: ", x1.varValue)
    print("Artillery batteries: ", x2.varValue)
else:
    print("The model is infeasible")
