
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bacon = m.addVar(name="strips_of_bacon", lb=0)
potatoes = m.addVar(name="potatoes", lb=0)


# Set objective function
m.setObjective(9*bacon**2 + 3*bacon*potatoes + 7*bacon + 2*potatoes, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*bacon + 4*potatoes >= 8, "healthiness_min")
m.addConstr(6*bacon + 3*potatoes >= 21, "sourness_min")
m.addConstr(10*bacon**2 + 7*potatoes**2 >= 29, "iron_min")
m.addConstr(10*bacon**2 + 1*potatoes**2 >= 20, "cost_min")
m.addConstr(-2*bacon**2 + 5*potatoes**2 >= 0, "bacon_potatoes_relation")
m.addConstr(2*bacon**2 + 4*potatoes**2 <= 41, "healthiness_squared_max")
m.addConstr(2*bacon + 4*potatoes <= 41, "healthiness_max")
m.addConstr(6*bacon + 3*potatoes <= 41, "sourness_max")
m.addConstr(10*bacon + 7*potatoes <= 52, "iron_max")
m.addConstr(10*bacon + 1*potatoes <= 26, "cost_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('strips of bacon: %g' % bacon.x)
    print('potatoes: %g' % potatoes.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

