
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="strips_of_bacon")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="potatoes")

# Objective function: Maximize
m.setObjective(9*x0**2 + 3*x0*x1 + 7*x0 + 2*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(2*x0 + 4*x1 >= 8, "healthiness_rating")
m.addConstr(6*x0 + 3*x1 >= 21, "sourness_index")
m.addConstr(10*x0**2 + 7*x1**2 >= 29, "iron_content_squared")
m.addConstr(10*x0**2 + x1**2 >= 20, "cost_constraint_squared")
m.addConstr(-2*x0**2 + 5*x1**2 >= 0, "strips_and_potatoes")
m.addConstr(2*x0 + 4*x1 <= 41, "max_healthiness_rating_linear")
m.addConstr(6*x0 + 3*x1 <= 41, "max_sourness_index")
m.addConstr(10*x0 + 7*x1 <= 52, "max_iron_content_linear")
m.addConstr(10*x0 + x1 <= 26, "budget_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Strips of bacon: {x0.x}")
    print(f"Potatoes: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
