
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="strips_of_bacon", lb=-gp.GRB.INFINITY)
x2 = m.addVar(name="potatoes", lb=-gp.GRB.INFINITY)

# Define the objective function
m.setObjective(9*x1**2 + 3*x1*x2 + 7*x1 + 2*x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(2*x1 + 4*x2 >= 8, name="healthiness_rating")
m.addConstr(6*x1 + 3*x2 >= 21, name="sourness_index")
m.addConstr(10*x1**2 + 7*x2**2 >= 29, name="milligrams_of_iron")
m.addConstr(10*x1**2 + x2**2 >= 20, name="cost_constraint_1")
m.addConstr(-2*x1**2 + 5*x2**2 >= 0, name="relationship_between_x1_x2")
m.addConstr(2*x1**2 + 4*x2**2 <= 41, name="healthiness_rating_squared")
m.addConstr(2*x1 + 4*x2 <= 41, name="healthiness_rating_linear")
m.addConstr(6*x1 + 3*x2 <= 41, name="sourness_index_linear")
m.addConstr(10*x1 + 7*x2 <= 52, name="milligrams_of_iron_linear")
m.addConstr(10*x1 + x2 <= 26, name="cost_constraint_2")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Strips of bacon: ", x1.varValue)
    print("Potatoes: ", x2.varValue)
else:
    print("The model is infeasible")
