
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x = [m.addVar(lb=0, name=f'x{i}') for i in range(5)]

# Set the variable bounds based on given equalities
m.addConstr(x[0] == 1, name='jean_org')
m.addConstr(6 * x[0] == 6, name='jean_dollar')
m.addConstr(2 * x[0] == 2, name='jean_quit')

m.addConstr(x[1] == 1, name='peggy_org')
m.addConstr(7 * x[1] == 7, name='peggy_dollar')
m.addConstr(8 * x[1] == 8, name='peggy_quit')

m.addConstr(x[2] == 1, name='bill_org')
m.addConstr(9 * x[2] == 9, name='bill_dollar')
m.addConstr(3 * x[2] == 3, name='bill_quit')

m.addConstr(x[3] == 1, name='hank_org')
m.addConstr(9 * x[3] == 9, name='hank_dollar')
m.addConstr(2 * x[3] == 2, name='hank_quit')

m.addConstr(x[4] == 1, name='bobby_org')
m.addConstr(13 * x[4] == 13, name='bobby_dollar')
m.addConstr(6 * x[4] == 6, name='bobby_quit')

# Add constraints
m.addConstr(9 * x[3] + 13 * x[4] >= 15)
m.addConstr(6 * x[0] + 9 * x[3] + 13 * x[4] >= 18)
m.addConstr(2 * x[0] + 2 * x[3] >= 30)
m.addConstr(8 * x[1] + 3 * x[2] >= 56)
m.addConstr(3 * x[2] + 2 * x[3] >= 23)
m.addConstr(8 * x[1] + 6 * x[4] >= 22)
m.addConstr(2 * x[0] + 8 * x[1] >= 31)
m.addConstr(12 * x[0] + 4 * x[1] <= 60)
m.addConstr(12 * x[0] + 12 * x[4] <= 72)
m.addConstr(12 * x[0] + 11 * x[3] <= 84)
m.addConstr(12 * x[0] + 3 * x[2] <= 158)
m.addConstr(11 * x[3] + 12 * x[4] <= 100)
m.addConstr(4 * x[1] + 11 * x[3] <= 73)
m.addConstr(3 * x[2] + 12 * x[4] <= 92)
m.addConstr(3 * x[2] + 11 * x[3] <= 125)
m.addConstr(4 * x[1] + 3 * x[2] <= 46)
m.addConstr(12 * x[0] + 3 * x[2] + 11 * x[3] <= 36)
m.addConstr(3 * x[2] + 11 * x[3] + 12 * x[4] <= 125)
m.addConstr(12 * x[0] + 4 * x[1] + 3 * x[2] <= 87)
m.addConstr(4 * x[1] + 11 * x[3] + 12 * x[4] <= 95)
m.addConstr(4 * x[1] + 3 * x[2] + 12 * x[4] <= 121)
m.addConstr(12 * x[0] + 4 * x[1] + 11 * x[3] <= 156)
m.addConstr(12 * x[0] + 4 * x[1] + 3 * x[2] + 11 * x[3] + 12 * x[4] <= 156)
m.addConstr(7 * x[1] + 9 * x[2] <= 104)
m.addConstr(6 * x[0] + 9 * x[2] <= 62)
m.addConstr(9 * x[2] + 9 * x[3] <= 27)
m.addConstr(7 * x[1] + 13 * x[4] <= 37)
m.addConstr(9 * x[2] + 9 * x[3] + 13 * x[4] <= 87)
m.addConstr(6 * x[0] + 9 * x[2] + 9 * x[3] <= 37)
m.addConstr(6 * x[0] + 7 * x[1] + 9 * x[3] <= 104)
m.addConstr(6 * x[0] + 7 * x[1] + 9 * x[2] + 9 * x[3] + 13 * x[4] <= 104)
m.addConstr(3 * x[2] + 2 * x[3] <= 205)
m.addConstr(2 * x[0] + 6 * x[4] <= 278)
m.addConstr(2 * x[0] + 3 * x[2] <= 226)
m.addConstr(2 * x[0] + 2 * x[3] <= 179)
m.addConstr(3 * x[2] + 6 * x[4] <= 159)
m.addConstr(2 * x[0] + 2 * x[3] + 6 * x[4] <= 286)
m.addConstr(8 * x[1] + 2 * x[3] + 6 * x[4] <= 214)
m.addConstr(3 * x[2] + 2 * x[3] + 6 * x[4] <= 153)
m.addConstr(2 * x[0] + 8 * x[1] + 3 * x[2] + 2 * x[3] + 6 * x[4] <= 153)

# Objective function
m.setObjective(1.23 * x[0] + 5.77 * x[1] + 2.39 * x[2] + 7.61 * x[3] + 2.8 * x[4], gurobi.GRB.MAXIMIZE)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print('Objective: %s' % m.objVal)
    for i in range(5):
        print(f'x{i}: {x[i].x}')
else:
    print('No solution found')
