
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("plant_optimization")

    # Create variables
    aloe_vera = m.addVar(vtype=gp.GRB.INTEGER, name="aloe_vera")
    begonias = m.addVar(vtype=gp.GRB.INTEGER, name="begonias")

    # Set objective function
    m.setObjective(7.44 * aloe_vera + 7.67 * begonias, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(22 * aloe_vera + 5 * begonias >= 14, "cost_min")
    m.addConstr(18 * aloe_vera + 13 * begonias >= 59, "water_min")
    m.addConstr(6 * aloe_vera + 8 * begonias >= 59, "growth_min")
    m.addConstr(3 * aloe_vera + 17 * begonias >= 42, "space_min")
    m.addConstr(22 * aloe_vera + 14 * begonias >= 31, "yield_min")
    m.addConstr(8 * aloe_vera - 5 * begonias >= 0, "custom_min")

    m.addConstr(22 * aloe_vera + 5 * begonias <= 40, "cost_max")
    m.addConstr(18 * aloe_vera + 13 * begonias <= 108, "water_max")
    m.addConstr(6 * aloe_vera + 8 * begonias <= 83, "growth_max")
    m.addConstr(3 * aloe_vera + 17 * begonias <= 72, "space_max")
    m.addConstr(22 * aloe_vera + 14 * begonias <= 76, "yield_max")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('aloe_vera:', aloe_vera.x)
        print('begonias:', begonias.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
