
import gurobi as gp

# Define the model
model = gp.Model()

# Define the variables
x1 = model.addVar(name="aloe_vera", vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="begonias", vtype=gp.GRB.INTEGER)

# Define the objective function
model.setObjective(7.44 * x1 + 7.67 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(22 * x1 + 5 * x2 >= 14, name="cost_min")
model.addConstr(18 * x1 + 13 * x2 >= 59, name="water_min")
model.addConstr(6 * x1 + 8 * x2 >= 59, name="growth_min")
model.addConstr(3 * x1 + 17 * x2 >= 42, name="space_min")
model.addConstr(22 * x1 + 14 * x2 >= 31, name="yield_min")
model.addConstr(8 * x1 - 5 * x2 >= 0, name="ratio_constraint")
model.addConstr(22 * x1 + 5 * x2 <= 40, name="cost_max")
model.addConstr(18 * x1 + 13 * x2 <= 108, name="water_max")
model.addConstr(6 * x1 + 8 * x2 <= 83, name="growth_max")
model.addConstr(3 * x1 + 17 * x2 <= 72, name="space_max")
model.addConstr(22 * x1 + 14 * x2 <= 76, name="yield_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Aloe Vera: {x1.varValue}")
    print(f"Begonias: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
