
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="milligrams of potassium")
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="milligrams of vitamin B9")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="milligrams of vitamin A")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="milligrams of calcium")
x4 = m.addVar(vtype=gp.GRB.INTEGER, name="milligrams of vitamin B4")


# Set objective function
m.setObjective(3.96 * x0 + 8.31 * x1 + 4.3 * x2 + 8.52 * x3 + 3.41 * x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(x0 + x4 >= 6)
m.addConstr(x1 + 5*x4 >= 12)
m.addConstr(9*x2 + 5*x4 >= 8)
m.addConstr(x0 + 9*x2 >= 7)
m.addConstr(3*x3 + 5*x4 >= 13)
m.addConstr(x1 + 3*x3 >= 19)
m.addConstr(x0 + 3*x3 >= 17)
m.addConstr(x1 + 9*x2 >= 7)
m.addConstr(x1 + 9*x2 + 3*x3 >= 15)
m.addConstr(x1 + 9*x2 + 5*x4 >= 15)
m.addConstr(x1 + 3*x3 + 5*x4 >= 15)
m.addConstr(x0 + x1 + 5*x4 >= 15)
m.addConstr(x0 + 9*x2 + 3*x3 >= 15)
m.addConstr(x1 + 9*x2 + 3*x3 >= 14)
m.addConstr(x1 + 9*x2 + 5*x4 >= 14)
m.addConstr(x1 + 3*x3 + 5*x4 >= 14)
m.addConstr(x0 + x1 + 5*x4 >= 14)
m.addConstr(x0 + 9*x2 + 3*x3 >= 14)
m.addConstr(x1 + 9*x2 + 3*x3 >= 11)
m.addConstr(x1 + 9*x2 + 5*x4 >= 11)
m.addConstr(x1 + 3*x3 + 5*x4 >= 11)
m.addConstr(x0 + x1 + 5*x4 >= 11)
m.addConstr(x0 + 9*x2 + 3*x3 >= 11)
m.addConstr(x1 + 9*x2 + 3*x3 >= 19)
m.addConstr(x1 + 9*x2 + 5*x4 >= 19)
m.addConstr(x1 + 3*x3 + 5*x4 >= 19)
m.addConstr(x0 + x1 + 5*x4 >= 19)
m.addConstr(x0 + 9*x2 + 3*x3 >= 19)
m.addConstr(x1 + 9*x2 + 3*x3 >= 14)
m.addConstr(x1 + 9*x2 + 5*x4 >= 14)
m.addConstr(x1 + 3*x3 + 5*x4 >= 14)
m.addConstr(x0 + x1 + 5*x4 >= 14)
m.addConstr(x0 + 9*x2 + 3*x3 >= 14)
m.addConstr(x0 + x1 + 9*x2 + 3*x3 + 5*x4 >= 14)
m.addConstr(6*x0 - 3*x1 >= 0)
m.addConstr(3*x0 - 10*x4 >= 0)
m.addConstr(-5*x1 + 7*x2 >= 0)
m.addConstr(x0 + 9*x2 + 5*x4 <= 32)
m.addConstr(x0 + 3*x3 + 5*x4 <= 54)
m.addConstr(x0 + 9*x2 + 3*x3 <= 56)
m.addConstr(x0 + x1 + 9*x2 <= 43)
m.addConstr(x0 + x1 + 9*x2 + 3*x3 + 5*x4 <= 99)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

