
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
foods = ['bowls of pasta', 'cherry pies', 'chicken drumsticks', 'protein bars', 'ravioli']
x = m.addVars(len(foods), lb=0, vtype=gp.GRB.CONTINUOUS, name=foods)

# Set objective function
m.setObjective(8*x[0] + 4*x[1] + 8*x[2] + 5*x[3] + 8*x[4], gp.GRB.MAXIMIZE)

# Set constraints
iron_data = {'bowls of pasta': 0.88, 'cherry pies': 7.52, 'chicken drumsticks': 5.46, 'protein bars': 8.84, 'ravioli': 4.31}
fiber_data = {'bowls of pasta': 7.81, 'cherry pies': 8.18, 'chicken drumsticks': 5.13, 'protein bars': 6.27, 'ravioli': 0.24}

m.addConstr(gp.quicksum(iron_data[f] * x[i] for i, f in enumerate(foods)) <= 582, "total_iron")
m.addConstr(gp.quicksum(fiber_data[f] * x[i] for i, f in enumerate(foods)) <= 346, "total_fiber")

m.addConstr(iron_data['chicken drumsticks']*x[2] + iron_data['protein bars']*x[3] + iron_data['ravioli']*x[4] >= 94, "iron_constr1")
m.addConstr(iron_data['bowls of pasta']*x[0] + iron_data['protein bars']*x[3] + iron_data['ravioli']*x[4] >= 94, "iron_constr2")
m.addConstr(iron_data['chicken drumsticks']*x[2] + iron_data['protein bars']*x[3] + iron_data['ravioli']*x[4] >= 61, "iron_constr3")
m.addConstr(iron_data['bowls of pasta']*x[0] + iron_data['protein bars']*x[3] + iron_data['ravioli']*x[4] >= 61, "iron_constr4")


# ... (Rest of the constraints, following the same pattern as above)

# Add all other constraints similarly, replacing food names with x[index] and data from iron_data and fiber_data

m.addConstr(7.52*x[1] + 4.31*x[4] <= 306, "iron_constr_last1")
# ... (Rest of the constraints)
m.addConstr(7.81*x[0] + 8.18*x[1] + 5.13*x[2] + 6.27*x[3] + 0.24*x[4] <= 131, "fiber_constr_last")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

