
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B12")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_A")


    # Set objective function
    obj = 5.59*x0**2 + 5.84*x0*x1 + 1.97*x0*x2 + 8.63*x1**2 + 8.1*x1*x2 + 2.13*x2**2 + 3.17*x0 + 8.16*x1 + 7.15*x2
    m.setObjective(obj, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8*x0 + 20*x1 + 4*x2 <= 60, "immune_support_index")
    m.addConstr(8*x0**2 + 4*x2**2 >= 11, "combined_immune_support_1")
    m.addConstr(8*x0 + 20*x1 >= 14, "combined_immune_support_2")
    m.addConstr(8*x0 + 20*x1 + 4*x2 >= 16, "combined_immune_support_3")
    m.addConstr(-5*x1 + 4*x2 >= 0, "constraint_4")
    m.addConstr(8*x0**2 + 20*x1**2 + 4*x2**2 <= 58, "combined_immune_support_4")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('zinc:', x0.x)
        print('vitamin_B12:', x1.x)
        print('vitamin_A:', x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
