
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3")

    # Objective function
    model.setObjective(5.59*x1**2 + 5.84*x1*x2 + 1.97*x1*x3 + 8.63*x2**2 + 8.1*x2*x3 + 2.13*x3**2 + 3.17*x1 + 8.16*x2 + 7.15*x3)

    # Constraints
    model.addConstr(8*x1 == 8, name="c1")
    model.addConstr(20*x2 == 20, name="c2")
    model.addConstr(4*x3 == 4, name="c3")
    model.addConstr(x1**2 + x3**2 >= 11, name="c4")
    model.addConstr(x1 + x2 >= 14, name="c5")
    model.addConstr(x1 + x2 + x3 >= 16, name="c6")
    model.addConstr(-5*x2 + 4*x3 >= 0, name="c7")
    model.addConstr(x1**2 + x2**2 + x3**2 <= 58, name="c8")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
