
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hot_dogs = m.addVar(vtype=gp.GRB.INTEGER, name="hot_dogs")
chicken_thighs = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_thighs")
kiwis = m.addVar(vtype=gp.GRB.INTEGER, name="kiwis")
black_beans = m.addVar(vtype=gp.GRB.INTEGER, name="black_beans")
chicken_drumsticks = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_drumsticks")

# Set objective function
m.setObjective(6.2 * hot_dogs + 1.61 * chicken_thighs + 2.93 * kiwis + 6.29 * black_beans + 8.4 * chicken_drumsticks, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * hot_dogs + 13 * chicken_thighs + 8 * kiwis + 9 * black_beans + 2 * chicken_drumsticks <= 116, "r0")
m.addConstr(15 * hot_dogs + 16 * chicken_thighs + 3 * kiwis + 8 * black_beans + 3 * chicken_drumsticks <= 201, "r1")
m.addConstr(8 * kiwis + 2 * chicken_drumsticks >= 10)
m.addConstr(13 * chicken_thighs + 9 * black_beans >= 18)
m.addConstr(9 * black_beans + 2 * chicken_drumsticks >= 15)
m.addConstr(5 * hot_dogs + 2 * chicken_drumsticks >= 9)
m.addConstr(8 * kiwis + 9 * black_beans >= 15)
m.addConstr(13 * chicken_thighs + 8 * kiwis >= 21)
m.addConstr(5 * hot_dogs + 13 * chicken_thighs >= 18)
m.addConstr(5 * hot_dogs + 8 * kiwis + 9 * black_beans >= 19)
m.addConstr(5 * hot_dogs + 13 * chicken_thighs + 8 * kiwis + 9 * black_beans + 2 * chicken_drumsticks >= 19)
m.addConstr(16 * chicken_thighs + 8 * black_beans >= 28)
m.addConstr(16 * chicken_thighs + 3 * kiwis >= 26)
m.addConstr(8 * black_beans + 3 * chicken_drumsticks >= 24)
m.addConstr(15 * hot_dogs + 3 * kiwis >= 39)
m.addConstr(3 * kiwis + 8 * black_beans >= 30)
m.addConstr(15 * hot_dogs + 8 * black_beans + 3 * chicken_drumsticks >= 20)
m.addConstr(15 * hot_dogs + 16 * chicken_thighs + 3 * kiwis + 8 * black_beans + 3 * chicken_drumsticks >= 20)
m.addConstr(-6 * hot_dogs + 1 * chicken_drumsticks >= 0)
m.addConstr(13 * chicken_thighs + 2 * chicken_drumsticks <= 65)
m.addConstr(8 * kiwis + 2 * chicken_drumsticks <= 49)
m.addConstr(5 * hot_dogs + 9 * black_beans <= 28)
m.addConstr(13 * chicken_thighs + 9 * black_beans <= 31)
m.addConstr(5 * hot_dogs + 8 * kiwis + 2 * chicken_drumsticks <= 53)
m.addConstr(5 * hot_dogs + 9 * black_beans + 2 * chicken_drumsticks <= 79)
m.addConstr(5 * hot_dogs + 13 * chicken_thighs + 9 * black_beans <= 100)
m.addConstr(3 * kiwis + 3 * chicken_drumsticks <= 99)
m.addConstr(15 * hot_dogs + 16 * chicken_thighs <= 77)
m.addConstr(8 * black_beans + 3 * chicken_drumsticks <= 65)
m.addConstr(16 * chicken_thighs + 8 * black_beans <= 124)
m.addConstr(16 * chicken_thighs + 3 * chicken_drumsticks <= 85)
m.addConstr(15 * hot_dogs + 3 * kiwis <= 118)
m.addConstr(15 * hot_dogs + 3 * chicken_drumsticks <= 100)
m.addConstr(16 * chicken_thighs + 3 * kiwis <= 128)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
