
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="hot_dogs", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="chicken_thighs", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="kiwis", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="black_beans", vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name="chicken_drumsticks", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(6.2*x0 + 1.61*x1 + 2.93*x2 + 6.29*x3 + 8.4*x4, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(5*x0 >= 5)
m.addConstr(13*x1 >= 13)
m.addConstr(8*x2 >= 8)
m.addConstr(9*x3 >= 9)
m.addConstr(2*x4 >= 2)
m.addConstr(8*x2 + 2*x4 >= 10)
m.addConstr(13*x1 + 9*x3 >= 18)
m.addConstr(9*x3 + 2*x4 >= 15)
m.addConstr(5*x0 + 2*x4 >= 9)
m.addConstr(8*x2 + 9*x3 >= 15)
m.addConstr(13*x1 + 8*x2 >= 21)
m.addConstr(5*x0 + 13*x1 >= 18)
m.addConstr(5*x0 + 8*x2 + 9*x3 >= 19)
m.addConstr(5*x0 + 13*x1 + 8*x2 + 9*x3 + 2*x4 >= 19)
m.addConstr(16*x1 + 8*x3 >= 28)
m.addConstr(16*x1 + 3*x2 >= 26)
m.addConstr(8*x3 + 3*x4 >= 24)
m.addConstr(15*x0 + 3*x2 >= 39)
m.addConstr(3*x2 + 8*x3 >= 30)
m.addConstr(15*x0 + 8*x3 + 3*x4 >= 20)
m.addConstr(15*x0 + 16*x1 + 3*x2 + 8*x3 + 3*x4 >= 20)
m.addConstr(-6*x0 + x4 >= 0)
m.addConstr(13*x1 + 2*x4 <= 65)
m.addConstr(8*x2 + 2*x4 <= 49)
m.addConstr(5*x0 + 9*x3 <= 28)
m.addConstr(13*x1 + 9*x3 <= 31)
m.addConstr(5*x0 + 8*x2 + 2*x4 <= 53)
m.addConstr(5*x0 + 9*x3 + 2*x4 <= 79)
m.addConstr(5*x0 + 13*x1 + 9*x3 <= 100)
m.addConstr(3*x2 + 3*x4 <= 99)
m.addConstr(15*x0 + 16*x1 <= 77)
m.addConstr(8*x3 + 3*x4 <= 65)
m.addConstr(16*x1 + 8*x3 <= 124)
m.addConstr(16*x1 + 3*x4 <= 85)
m.addConstr(15*x0 + 3*x2 <= 118)
m.addConstr(15*x0 + 3*x4 <= 100)
m.addConstr(16*x1 + 3*x2 <= 128)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Hot dogs: ", x0.varValue)
    print("Chicken thighs: ", x1.varValue)
    print("Kiwis: ", x2.varValue)
    print("Black beans: ", x3.varValue)
    print("Chicken drumsticks: ", x4.varValue)
else:
    print("No optimal solution found")
