
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
pizza = model.addVar(vtype=GRB.CONTINUOUS, name="pizza")
kiwis = model.addVar(vtype=GRB.CONTINUOUS, name="kiwis")
granola_bars = model.addVar(vtype=GRB.CONTINUOUS, name="granola_bars")
pickles = model.addVar(vtype=GRB.CONTINUOUS, name="pickles")
steaks = model.addVar(vtype=GRB.CONTINUOUS, name="steaks")


# Set objective function
model.setObjective(7 * pizza + 4 * kiwis + 9 * granola_bars + 6 * pickles + 1 * steaks, GRB.MAXIMIZE)

# Add constraints
model.addConstr(22 * granola_bars + 20 * steaks >= 113)
model.addConstr(19 * pizza + 4 * pickles + 20 * steaks >= 80)
model.addConstr(19 * pizza + 22 * granola_bars + 4 * pickles >= 80)
model.addConstr(19 * pizza + 4 * pickles + 20 * steaks >= 94)
model.addConstr(19 * pizza + 22 * granola_bars + 4 * pickles >= 94)
model.addConstr(15 * pizza + 14 * kiwis >= 34)
model.addConstr(15 * pizza + 5 * steaks >= 28)
model.addConstr(15 * pizza + 14 * kiwis + 5 * steaks >= 38)
model.addConstr(14 * kiwis + 16 * pickles + 5 * steaks >= 38)
model.addConstr(15 * pizza + 19 * granola_bars + 5 * steaks >= 38)
model.addConstr(14 * kiwis + 19 * granola_bars + 5 * steaks >= 38)
model.addConstr(15 * pizza + 19 * granola_bars + 16 * pickles >= 38)
model.addConstr(15 * pizza + 14 * kiwis + 16 * pickles >= 38)
model.addConstr(15 * pizza + 14 * kiwis + 5 * steaks >= 33)
model.addConstr(14 * kiwis + 16 * pickles + 5 * steaks >= 33)
model.addConstr(15 * pizza + 19 * granola_bars + 5 * steaks >= 33)
model.addConstr(14 * kiwis + 19 * granola_bars + 5 * steaks >= 33)
model.addConstr(15 * pizza + 19 * granola_bars + 16 * pickles >= 33)
model.addConstr(15 * pizza + 14 * kiwis + 16 * pickles >= 33)
# ... (rest of the constraints)



# Resource Constraints
model.addConstr(19 * pizza <= 599)
model.addConstr(15 * pizza <= 227)
model.addConstr(16 * pizza <= 711)
model.addConstr(9 * kiwis <= 599)
model.addConstr(14 * kiwis <= 227)
model.addConstr(6 * kiwis <= 711)
model.addConstr(22 * granola_bars <= 599)
model.addConstr(19 * granola_bars <= 227)
model.addConstr(5 * granola_bars <= 711)
model.addConstr(4 * pickles <= 599)
model.addConstr(16 * pickles <= 227)
model.addConstr(5 * pickles <= 711)
model.addConstr(20 * steaks <= 599)
model.addConstr(5 * steaks <= 227)
model.addConstr(9 * steaks <= 711)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % model.status)

