
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
security_onions = m.addVar(vtype=gp.GRB.INTEGER, name="security_onions")
pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
deployed_decoys = m.addVar(vtype=gp.GRB.INTEGER, name="deployed_decoys")
security_engineers = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")

# Set objective function
m.setObjective(1.88 * security_onions + 7.42 * pen_testers + 4.68 * deployed_decoys + 1.93 * security_engineers, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(18 * security_onions + 4 * pen_testers + 18 * deployed_decoys + 4 * security_engineers <= 273, "bandwidth_constraint")
m.addConstr(13 * security_onions + 19 * pen_testers + 6 * deployed_decoys + 18 * security_engineers <= 143, "computational_load_constraint")
m.addConstr(4 * pen_testers + 18 * deployed_decoys >= 67, "bandwidth_constraint1")
m.addConstr(18 * security_onions + 4 * pen_testers >= 55, "bandwidth_constraint2")
m.addConstr(4 * pen_testers + 4 * security_engineers >= 39, "bandwidth_constraint3")
m.addConstr(18 * security_onions + 4 * pen_testers + 18 * deployed_decoys >= 41, "bandwidth_constraint4")
m.addConstr(4 * pen_testers + 18 * deployed_decoys + 4 * security_engineers >= 41, "bandwidth_constraint5")
m.addConstr(4 * pen_testers + 18 * deployed_decoys + 4 * security_engineers >= 67, "bandwidth_constraint6")
m.addConstr(18 * security_onions + 4 * pen_testers + 18 * deployed_decoys + 4 * security_engineers >= 67, "bandwidth_constraint7")
m.addConstr(13 * security_onions + 19 * pen_testers >= 22, "computational_load_constraint1")
m.addConstr(13 * security_onions + 18 * security_engineers >= 22, "computational_load_constraint2")
m.addConstr(13 * security_onions + 6 * deployed_decoys >= 15, "computational_load_constraint3")
m.addConstr(19 * pen_testers + 6 * deployed_decoys >= 21, "computational_load_constraint4")
m.addConstr(13 * security_onions + 19 * pen_testers + 6 * deployed_decoys >= 21, "computational_load_constraint5")
m.addConstr(13 * security_onions + 19 * pen_testers + 6 * deployed_decoys + 18 * security_engineers >= 21, "computational_load_constraint6")
m.addConstr(-1 * pen_testers + 2 * security_engineers >= 0, "constraint1")
m.addConstr(-7 * security_onions + 5 * pen_testers >= 0, "constraint2")
m.addConstr(18 * security_onions + 4 * pen_testers <= 197, "bandwidth_constraint8")
m.addConstr(18 * security_onions + 4 * pen_testers + 4 * security_engineers <= 99, "bandwidth_constraint9")
m.addConstr(18 * security_onions + 18 * deployed_decoys + 4 * security_engineers <= 103, "bandwidth_constraint10")
m.addConstr(4 * pen_testers + 18 * deployed_decoys + 4 * security_engineers <= 164, "bandwidth_constraint11")
m.addConstr(13 * security_onions + 6 * deployed_decoys <= 115, "computational_load_constraint7")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

