
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="security_onions", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="pen_testers", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="deployed_decoys", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="security_engineers", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(1.88 * x0 + 7.42 * x1 + 4.68 * x2 + 1.93 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(18 * x0 + 4 * x1 + 18 * x2 + 4 * x3 <= 273)
    model.addConstr(13 * x0 + 19 * x1 + 6 * x2 + 18 * x3 <= 143)
    model.addConstr(4 * x1 + 18 * x2 >= 67)
    model.addConstr(18 * x0 + 4 * x1 >= 55)
    model.addConstr(4 * x1 + 4 * x3 >= 39)
    model.addConstr(18 * x0 + 4 * x1 + 18 * x2 >= 41)
    model.addConstr(4 * x1 + 18 * x2 + 4 * x3 >= 41)
    model.addConstr(18 * x0 + 4 * x1 + 18 * x2 >= 67)
    model.addConstr(4 * x1 + 18 * x2 + 4 * x3 >= 67)
    model.addConstr(18 * x0 + 4 * x1 + 18 * x2 + 4 * x3 >= 67)
    model.addConstr(13 * x0 + 19 * x1 >= 22)
    model.addConstr(13 * x0 + 18 * x3 >= 22)
    model.addConstr(13 * x0 + 6 * x2 >= 15)
    model.addConstr(19 * x1 + 6 * x2 >= 21)
    model.addConstr(13 * x0 + 19 * x1 + 6 * x2 >= 21)
    model.addConstr(13 * x0 + 19 * x1 + 6 * x2 + 18 * x3 >= 21)
    model.addConstr(-x1 + 2 * x3 >= 0)
    model.addConstr(-7 * x0 + 5 * x1 >= 0)
    model.addConstr(18 * x0 + 4 * x1 <= 197)
    model.addConstr(18 * x0 + 4 * x1 + 4 * x3 <= 99)
    model.addConstr(18 * x0 + 18 * x2 + 4 * x3 <= 103)
    model.addConstr(4 * x1 + 18 * x2 + 4 * x3 <= 164)
    model.addConstr(13 * x0 + 6 * x2 <= 115)

    # Non-negativity constraints for integer variables (implied by Gurobi's integer type)
    # x0, x1, x2, x3 >= 0 is implied by vtype=gurobi.GRB.INTEGER

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Security Onions: {x0.varValue}")
        print(f"Pen Testers: {x1.varValue}")
        print(f"Deployed Decoys: {x2.varValue}")
        print(f"Security Engineers: {x3.varValue}")
        print(f"Objective Function Value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
