
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_d = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_d")
    vitamin_b12 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")
    vitamin_e = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_e")


    # Set objective function
    m.setObjective(5.42 * vitamin_d + 3.19 * vitamin_b12 + 1.61 * vitamin_e, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7 * vitamin_d + 8 * vitamin_e >= 41, "c1")
    m.addConstr(7 * vitamin_d + 6 * vitamin_b12 >= 22, "c2")
    m.addConstr(7 * vitamin_d + 6 * vitamin_b12 + 8 * vitamin_e >= 22, "c3")
    m.addConstr(5 * vitamin_d + 6 * vitamin_e >= 15, "c4")
    m.addConstr(5 * vitamin_d + 2 * vitamin_b12 + 6 * vitamin_e >= 15, "c5")
    m.addConstr(8 * vitamin_b12 + 7 * vitamin_e >= 35, "c6")
    m.addConstr(1 * vitamin_d + 8 * vitamin_b12 + 7 * vitamin_e >= 35, "c7")
    m.addConstr(6 * vitamin_d + 3 * vitamin_e >= 28, "c8")
    m.addConstr(7 * vitamin_b12 + 3 * vitamin_e >= 16, "c9")
    m.addConstr(6 * vitamin_d + 7 * vitamin_b12 + 3 * vitamin_e >= 16, "c10")
    m.addConstr(7 * vitamin_d + 6 * vitamin_b12 + 8 * vitamin_e <= 110,"c11")
    m.addConstr(5 * vitamin_d + 6 * vitamin_e <= 48, "c12")
    m.addConstr(5 * vitamin_d + 2 * vitamin_b12 + 6 * vitamin_e <= 64, "c13")
    m.addConstr(1 * vitamin_d + 7 * vitamin_e <= 114, "c14")
    m.addConstr(8 * vitamin_b12 + 7 * vitamin_e <= 108, "c15")
    m.addConstr(6 * vitamin_d + 7 * vitamin_b12 + 3 * vitamin_e <= 60, "c16")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_d: %g' % vitamin_d.x)
        print('vitamin_b12: %g' % vitamin_b12.x)
        print('vitamin_e: %g' % vitamin_e.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
