
import gurobi

def optimize_vitamins():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0, ub=None)  # milligrams of vitamin D
    x1 = model.addVar(name="x1", lb=0, ub=None)  # milligrams of vitamin B12
    x2 = model.addVar(name="x2", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin E

    # Objective function
    model.setObjective(5.42 * x0 + 3.19 * x1 + 1.61 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(7 * x0 + 6 * x1 + 8 * x2 >= 41)  
    model.addConstr(7 * x0 + 6 * x1 >= 22)
    model.addConstr(7 * x0 + 6 * x1 + 8 * x2 >= 22)
    model.addConstr(5 * x0 + 6 * x2 >= 15)
    model.addConstr(5 * x0 + 2 * x1 + 6 * x2 >= 15)
    model.addConstr(8 * x1 + 7 * x2 >= 35)
    model.addConstr(x0 + 8 * x1 + 7 * x2 >= 35)
    model.addConstr(6 * x0 + 3 * x2 >= 28)
    model.addConstr(7 * x1 + 3 * x2 >= 16)
    model.addConstr(6 * x0 + 7 * x1 + 3 * x2 >= 16)
    model.addConstr(7 * x0 + 6 * x1 + 8 * x2 <= 110)
    model.addConstr(5 * x0 + 2 * x1 + 6 * x2 <= 48)
    model.addConstr(5 * x0 + 2 * x1 + 6 * x2 <= 64)
    model.addConstr(x0 + 7 * x2 <= 114)
    model.addConstr(8 * x1 + 7 * x2 <= 108)
    model.addConstr(6 * x0 + 7 * x1 + 3 * x2 <= 60)

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin D: {x0.varValue}")
        print(f"Milligrams of vitamin B12: {x1.varValue}")
        print(f"Milligrams of vitamin E: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
