
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("likelihood_optimization")

    # Create variables
    paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")
    dale = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="dale")
    jean = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="jean")
    ringo = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ringo")

    # Set objective function
    model.setObjective(6*paul + 1*dale + 4*jean + 2*ringo, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(1.97*dale + 11.12*jean >= 17)
    model.addConstr(7.79*paul + 1.97*dale >= 22)
    model.addConstr(7.79*paul + 11.12*jean >= 22)
    model.addConstr(7.79*paul + 1.97*dale + 11.12*jean >= 35)
    model.addConstr(7.79*paul + 11.12*jean + 0.46*ringo >= 35)
    model.addConstr(1.97*dale + 11.12*jean + 0.46*ringo >= 35)
    model.addConstr(7.79*paul + 1.97*dale + 11.12*jean >= 26)
    model.addConstr(7.79*paul + 11.12*jean + 0.46*ringo >= 26)
    model.addConstr(1.97*dale + 11.12*jean + 0.46*ringo >= 26)
    model.addConstr(7.79*paul + 1.97*dale + 11.12*jean >= 17)
    model.addConstr(7.79*paul + 11.12*jean + 0.46*ringo >= 17)
    model.addConstr(1.97*dale + 11.12*jean + 0.46*ringo >= 17)
    model.addConstr(7.79*paul + 0.46*ringo <= 64)
    model.addConstr(7.79*paul + 11.12*jean <= 106)
    model.addConstr(7.79*paul + 1.97*dale <= 44)
    model.addConstr(1.97*dale + 0.46*ringo <= 84)
    model.addConstr(7.79*paul + 1.97*dale + 11.12*jean + 0.46*ringo <= 84)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
