
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(lb=0, name="hours_worked_by_Paul", vtype=gp.GRB.CONTINUOUS)
x2 = m.addVar(lb=0, name="hours_worked_by_Dale", vtype=gp.GRB.INTEGER)
x3 = m.addVar(lb=0, name="hours_worked_by_Jean", vtype=gp.GRB.INTEGER)
x4 = m.addVar(lb=0, name="hours_worked_by_Ringo", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(6*x1 + x2 + 4*x3 + 2*x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.97*x2 + 11.12*x3 >= 17)
m.addConstr(7.79*x1 + 1.97*x2 >= 22)
m.addConstr(7.79*x1 + 11.12*x3 >= 22)
m.addConstr(7.79*x1 + 1.97*x2 + 11.12*x3 >= 35)
m.addConstr(7.79*x1 + 11.12*x3 + 0.46*x4 >= 35)
m.addConstr(1.97*x2 + 11.12*x3 + 0.46*x4 >= 35)
m.addConstr(7.79*x1 + 1.97*x2 + 11.12*x3 >= 26)
m.addConstr(7.79*x1 + 11.12*x3 + 0.46*x4 >= 26)
m.addConstr(1.97*x2 + 11.12*x3 + 0.46*x4 >= 26)
m.addConstr(7.79*x1 + 1.97*x2 + 11.12*x3 >= 17)
m.addConstr(7.79*x1 + 11.12*x3 + 0.46*x4 >= 17)
m.addConstr(1.97*x2 + 11.12*x3 + 0.46*x4 >= 17)
m.addConstr(7.79*x1 + 0.46*x4 <= 64)
m.addConstr(7.79*x1 + 11.12*x3 <= 106)
m.addConstr(7.79*x1 + 1.97*x2 <= 44)
m.addConstr(1.97*x2 + 0.46*x4 <= 84)
m.addConstr(7.79*x1 + 1.97*x2 + 11.12*x3 + 0.46*x4 <= 84)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Paul: ", x1.varValue)
    print("Hours worked by Dale: ", x2.varValue)
    print("Hours worked by Jean: ", x3.varValue)
    print("Hours worked by Ringo: ", x4.varValue)
else:
    print("The problem is infeasible")
