
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("plant_optimization")

# Create variables
pansies = m.addVar(vtype=GRB.INTEGER, name="pansies")
verbenas = m.addVar(vtype=GRB.INTEGER, name="verbenas")
potato_vines = m.addVar(vtype=GRB.INTEGER, name="potato_vines")
aloe_vera = m.addVar(vtype=GRB.INTEGER, name="aloe_vera")

# Set objective function
m.setObjective(8*pansies**2 + 2*pansies*verbenas + 2*pansies*potato_vines + pansies*aloe_vera + 8*verbenas**2 + 4*verbenas*potato_vines + 8*verbenas*aloe_vera + 2*potato_vines**2 + potato_vines*aloe_vera + 6*aloe_vera**2 + 4*pansies + 2*verbenas + 4*potato_vines + 2*aloe_vera, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*pansies + 11*verbenas + 10*potato_vines + 6*aloe_vera <= 73)
m.addConstr(2*pansies + 9*verbenas + 9*potato_vines + 7*aloe_vera <= 73)
m.addConstr(3*pansies + 9*verbenas + potato_vines + 11*aloe_vera <= 200)
m.addConstr(2*pansies + 9*potato_vines >= 17*144)
m.addConstr(9*verbenas + 9*potato_vines >= 17*144)
m.addConstr(2*pansies + 9*potato_vines + 7*aloe_vera >= 16*144)
m.addConstr(2*pansies + 9*verbenas + 7*aloe_vera >= 16*144)
m.addConstr(2**2*pansies**2 + 9**2*potato_vines**2 + 7**2*aloe_vera**2 >= 10*144)
m.addConstr(2*pansies + 9*verbenas + 7*aloe_vera >= 10*144)
m.addConstr(3*pansies + potato_vines >= 22)
m.addConstr(3*pansies + 9*verbenas + potato_vines >= 35)
m.addConstr(6*pansies - 4*verbenas + potato_vines >= 0)
m.addConstr(10*potato_vines + 6*aloe_vera <= 28)
m.addConstr(5**2*pansies**2 + 11**2*verbenas**2 <= 37)
m.addConstr(5*pansies + 11*verbenas + 10*potato_vines + 6*aloe_vera <= 37)
m.addConstr(9**2*verbenas**2 + 7**2*aloe_vera**2 <= 23*144)
m.addConstr(9*potato_vines + 7*aloe_vera <= 28*144)
m.addConstr(2*pansies + 9*verbenas + 7*aloe_vera <= 42*144)
m.addConstr(9**2*verbenas**2 + 9**2*potato_vines**2 + 7**2*aloe_vera**2 <= 46*144)
m.addConstr(2**2*pansies**2 + 9**2*verbenas**2 + 9**2*potato_vines**2 <= 54*144)
m.addConstr(2*pansies + 9*verbenas + 9*potato_vines + 7*aloe_vera <= 54*144)
m.addConstr(9**2*verbenas**2 + potato_vines**2 <= 86)
m.addConstr(potato_vines + 11*aloe_vera <= 60)
m.addConstr(3*pansies + potato_vines <= 65)
m.addConstr(3**2*pansies**2 + 9**2*verbenas**2 + 11**2*aloe_vera**2 <= 51)
m.addConstr(9*verbenas + potato_vines + 11*aloe_vera <= 59)
m.addConstr(3*pansies + 9*verbenas + potato_vines <= 67)
m.addConstr(3*pansies + 9*verbenas + potato_vines + 11*aloe_vera <= 67)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

