
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="pansies", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="verbenas", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="potato_vines", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="aloe_vera", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(8*x0**2 + 2*x0*x1 + 2*x0*x2 + x0*x3 + 8*x1**2 + 4*x1*x2 + 8*x1*x3 + 2*x2**2 + x2*x3 + 6*x3**2 + 4*x0 + 2*x1 + 4*x2 + 2*x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x0 + 11*x1 + 10*x2 + 6*x3 <= 73)
m.addConstr(2*x0 + 9*x1 + 9*x2 + 7*x3 <= 73)
m.addConstr(3*x0 + 9*x1 + x2 + 11*x3 <= 200)
m.addConstr(2*x0 + 9*x2 >= 17*144)
m.addConstr(9*x1 + 9*x2 >= 17*144)
m.addConstr(2*x0 + 9*x2 + 7*x3 >= 16*144)
m.addConstr(2*x0 + 9*x1 + 7*x3 >= 16*144)
m.addConstr(4*x0**2 + 81*x2**2 + 49*x3**2 >= 10*144)
m.addConstr(2*x0 + 9*x1 + 7*x3 >= 10*144)
m.addConstr(3*x0 + x2 >= 22)
m.addConstr(3*x0 + 9*x1 + x2 >= 35)
m.addConstr(6*x0 - 4*x1 + x2 >= 0)
m.addConstr(10*x2 + 6*x3 <= 28)
m.addConstr(25*x0**2 + 121*x1**2 <= 37)
m.addConstr(5*x0 + 11*x1 + 10*x2 + 6*x3 <= 37)
m.addConstr(121*x1**2 + 36*x3**2 <= 23*144)
m.addConstr(9*x2 + 7*x3 <= 28*144)
m.addConstr(2*x0 + 9*x1 + 7*x3 <= 42*144)
m.addConstr(81*x1**2 + 81*x2**2 + 36*x3**2 <= 46*144)
m.addConstr(4*x0**2 + 81*x1**2 + 81*x2**2 <= 54*144)
m.addConstr(4*x0**2 + 81*x1**2 + 81*x2**2 + 36*x3**2 <= 54*144)
m.addConstr(81*x1**2 + x2**2 <= 86)
m.addConstr(x2 + 11*x3 <= 60)
m.addConstr(3*x0 + x2 <= 65)
m.addConstr(9*x0**2 + 81*x1**2 + 36*x3**2 <= 51)
m.addConstr(9*x1 + x2 + 11*x3 <= 59)
m.addConstr(3*x0 + 9*x1 + x2 <= 67)
m.addConstr(3*x0 + 9*x1 + x2 + 11*x3 <= 67)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("pansies: ", x0.varValue)
    print("verbenas: ", x1.varValue)
    print("potato_vines: ", x2.varValue)
    print("aloe_vera: ", x3.varValue)
else:
    print("No solution found")
